/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.elementa.components;

import club.sk1er.mods.scrollabletooltips.elementa.UIComponent;
import club.sk1er.mods.scrollabletooltips.elementa.components.Window;
import club.sk1er.mods.scrollabletooltips.elementa.components.image.CacheableImage;
import club.sk1er.mods.scrollabletooltips.elementa.components.image.DefaultFailureImage;
import club.sk1er.mods.scrollabletooltips.elementa.components.image.DefaultLoadingImage;
import club.sk1er.mods.scrollabletooltips.elementa.components.image.ImageCache;
import club.sk1er.mods.scrollabletooltips.elementa.components.image.ImageProvider;
import club.sk1er.mods.scrollabletooltips.elementa.components.inspector.Inspector;
import club.sk1er.mods.scrollabletooltips.elementa.utils.ImageKt;
import club.sk1er.mods.scrollabletooltips.elementa.utils.ResourceCache;
import club.sk1er.mods.scrollabletooltips.universalcraft.UGraphics;
import club.sk1er.mods.scrollabletooltips.universalcraft.UMatrixStack;
import club.sk1er.mods.scrollabletooltips.universalcraft.utils.ReleasedDynamicTexture;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 E2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002EFB\u0017\b\u0017\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB+\b\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0019\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J?\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b!\u0010\"R\"\u0010$\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010\f\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010*R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010+R\"\u0010-\u001a\u00020,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\"\u00103\u001a\u00020,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u0010.\u001a\u0004\b4\u00100\"\u0004\b5\u00102R\u0011\u00106\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010'R\u0014\u0010\u000b\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010*R\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u00107R\"\u00109\u001a\u0002088\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\"\u0010?\u001a\u0002088\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010:\u001a\u0004\b@\u0010<\"\u0004\bA\u0010>R\u001a\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00030B8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010D\u00a8\u0006G"}, d2={"Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage;", "Lclub/sk1er/mods/scrollabletooltips/elementa/UIComponent;", "Lclub/sk1er/mods/scrollabletooltips/elementa/components/image/ImageProvider;", "Lclub/sk1er/mods/scrollabletooltips/elementa/components/image/CacheableImage;", "Lkotlin/Function0;", "Ljava/awt/image/BufferedImage;", "imageFunction", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "Ljava/util/concurrent/CompletableFuture;", "imageFuture", "loadingImage", "failureImage", "(Ljava/util/concurrent/CompletableFuture;Lgg/essential/elementa/components/image/ImageProvider;Lgg/essential/elementa/components/image/ImageProvider;)V", "Lclub/sk1er/mods/scrollabletooltips/universalcraft/utils/ReleasedDynamicTexture;", "texture", "", "applyTexture", "(Lclub/sk1er/mods/scrollabletooltips/universalcraft/utils/ReleasedDynamicTexture;)V", "Lclub/sk1er/mods/scrollabletooltips/universalcraft/UMatrixStack;", "matrixStack", "draw", "(Lclub/sk1er/mods/scrollabletooltips/universalcraft/UMatrixStack;)V", "", "x", "y", "width", "height", "Ljava/awt/Color;", "color", "drawImage", "(Lclub/sk1er/mods/scrollabletooltips/universalcraft/UMatrixStack;DDDDLjava/awt/Color;)V", "image", "supply", "(Lclub/sk1er/mods/scrollabletooltips/elementa/components/image/CacheableImage;)V", "", "destroy", "Z", "getDestroy", "()Z", "setDestroy", "(Z)V", "Lclub/sk1er/mods/scrollabletooltips/elementa/components/image/ImageProvider;", "Ljava/util/concurrent/CompletableFuture;", "", "imageHeight", "F", "getImageHeight", "()F", "setImageHeight", "(F)V", "imageWidth", "getImageWidth", "setImageWidth", "isLoaded", "Lclub/sk1er/mods/scrollabletooltips/universalcraft/utils/ReleasedDynamicTexture;", "Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage$TextureScalingMode;", "textureMagFilter", "Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage$TextureScalingMode;", "getTextureMagFilter", "()Lgg/essential/elementa/components/UIImage$TextureScalingMode;", "setTextureMagFilter", "(Lgg/essential/elementa/components/UIImage$TextureScalingMode;)V", "textureMinFilter", "getTextureMinFilter", "setTextureMinFilter", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "waiting", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Companion", "TextureScalingMode", "Elementa"})
public class UIImage
extends UIComponent
implements ImageProvider,
CacheableImage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompletableFuture<BufferedImage> imageFuture;
    @NotNull
    private final ImageProvider loadingImage;
    @NotNull
    private final ImageProvider failureImage;
    @Nullable
    private ReleasedDynamicTexture texture;
    @NotNull
    private final ConcurrentLinkedQueue<CacheableImage> waiting;
    private float imageWidth;
    private float imageHeight;
    private boolean destroy;
    @NotNull
    private TextureScalingMode textureMinFilter;
    @NotNull
    private TextureScalingMode textureMagFilter;
    @NotNull
    private static final ResourceCache defaultResourceCache = new ResourceCache(50);

    @JvmOverloads
    public UIImage(@NotNull CompletableFuture<BufferedImage> imageFuture, @NotNull ImageProvider loadingImage, @NotNull ImageProvider failureImage) {
        Intrinsics.checkNotNullParameter(imageFuture, (String)"imageFuture");
        Intrinsics.checkNotNullParameter((Object)loadingImage, (String)"loadingImage");
        Intrinsics.checkNotNullParameter((Object)failureImage, (String)"failureImage");
        this.imageFuture = imageFuture;
        this.loadingImage = loadingImage;
        this.failureImage = failureImage;
        this.waiting = new ConcurrentLinkedQueue();
        this.imageWidth = 1.0f;
        this.imageHeight = 1.0f;
        this.destroy = true;
        this.textureMinFilter = TextureScalingMode.NEAREST;
        this.textureMagFilter = TextureScalingMode.NEAREST;
        ((CompletableFuture)this.imageFuture.exceptionally(UIImage::_init_$lambda$0)).thenAcceptAsync(arg_0 -> UIImage._init_$lambda$1((Function1)new Function1<BufferedImage, Unit>(){

            public final void invoke(BufferedImage it) {
                if (it == null) {
                    this.setDestroy(false);
                    return;
                }
                this.setImageWidth(it.getWidth());
                this.setImageHeight(it.getHeight());
                imageFuture.obtrudeValue(null);
                final ReleasedDynamicTexture texture2 = UGraphics.getTexture(it);
                Window.Companion.enqueueRenderOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        ReleasedDynamicTexture releasedDynamicTexture = texture2;
                        if (releasedDynamicTexture != null) {
                            releasedDynamicTexture.uploadTexture();
                        }
                        texture = texture2;
                        while (!waiting.isEmpty()) {
                            ((CacheableImage)waiting.poll()).applyTexture(texture2);
                        }
                    }
                }));
            }
        }, arg_0));
    }

    public /* synthetic */ UIImage(CompletableFuture completableFuture, ImageProvider imageProvider, ImageProvider imageProvider2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            imageProvider = DefaultLoadingImage.INSTANCE;
        }
        if ((n & 4) != 0) {
            imageProvider2 = DefaultFailureImage.INSTANCE;
        }
        this(completableFuture, imageProvider, imageProvider2);
    }

    public final float getImageWidth() {
        return this.imageWidth;
    }

    public final void setImageWidth(float f) {
        this.imageWidth = f;
    }

    public final float getImageHeight() {
        return this.imageHeight;
    }

    public final void setImageHeight(float f) {
        this.imageHeight = f;
    }

    public final boolean getDestroy() {
        return this.destroy;
    }

    public final void setDestroy(boolean bl) {
        this.destroy = bl;
    }

    public final boolean isLoaded() {
        return this.texture != null;
    }

    @NotNull
    public final TextureScalingMode getTextureMinFilter() {
        return this.textureMinFilter;
    }

    public final void setTextureMinFilter(@NotNull TextureScalingMode textureScalingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)textureScalingMode), (String)"<set-?>");
        this.textureMinFilter = textureScalingMode;
    }

    @NotNull
    public final TextureScalingMode getTextureMagFilter() {
        return this.textureMagFilter;
    }

    public final void setTextureMagFilter(@NotNull TextureScalingMode textureScalingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)textureScalingMode), (String)"<set-?>");
        this.textureMagFilter = textureScalingMode;
    }

    @Deprecated(message="Please provide a completable future instead", replaceWith=@ReplaceWith(expression="CompletableFuture.supplyAsync(imageFunction)", imports={"java.util.concurrent.CompletableFuture"}), level=DeprecationLevel.ERROR)
    public UIImage(@NotNull Function0<? extends BufferedImage> imageFunction) {
        Intrinsics.checkNotNullParameter(imageFunction, (String)"imageFunction");
        CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> UIImage._init_$lambda$2(imageFunction));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(imageFunction)");
        this(completableFuture, null, null, 6, null);
    }

    @Override
    public void drawImage(@NotNull UMatrixStack matrixStack, double x, double y, double width, double height, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (this.texture != null) {
            ReleasedDynamicTexture releasedDynamicTexture = this.texture;
            Intrinsics.checkNotNull((Object)((Object)releasedDynamicTexture));
            ImageKt.drawTexture(matrixStack, releasedDynamicTexture, color, x, y, width, height, this.textureMinFilter.getGlMode$Elementa(), this.textureMagFilter.getGlMode$Elementa());
        } else if (this.imageFuture.isCompletedExceptionally()) {
            this.failureImage.drawImageCompat(matrixStack, x, y, width, height, color);
        } else {
            this.loadingImage.drawImageCompat(matrixStack, x, y, width, height, color);
        }
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        double x = this.getLeft();
        double y = this.getTop();
        double width = this.getWidth();
        double height = this.getHeight();
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            super.draw(matrixStack);
            return;
        }
        this.drawImage(matrixStack, x, y, width, height, color);
        super.draw(matrixStack);
    }

    @Override
    public void supply(@NotNull CacheableImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (this.texture != null) {
            image.applyTexture(this.texture);
            return;
        }
        this.waiting.add(image);
    }

    @Override
    public void applyTexture(@Nullable ReleasedDynamicTexture texture2) {
        this.texture = texture2;
        while (!this.waiting.isEmpty()) {
            this.waiting.poll().applyTexture(texture2);
        }
    }

    @JvmOverloads
    public UIImage(@NotNull CompletableFuture<BufferedImage> imageFuture, @NotNull ImageProvider loadingImage) {
        Intrinsics.checkNotNullParameter(imageFuture, (String)"imageFuture");
        Intrinsics.checkNotNullParameter((Object)loadingImage, (String)"loadingImage");
        this(imageFuture, loadingImage, null, 4, null);
    }

    @JvmOverloads
    public UIImage(@NotNull CompletableFuture<BufferedImage> imageFuture) {
        Intrinsics.checkNotNullParameter(imageFuture, (String)"imageFuture");
        this(imageFuture, null, null, 6, null);
    }

    private static final BufferedImage _init_$lambda$0(Throwable it) {
        it.printStackTrace();
        return null;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final BufferedImage _init_$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BufferedImage)$tmp0.invoke();
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofFile(@NotNull File file) {
        return Companion.ofFile(file);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofURL(@NotNull URL url) {
        return Companion.ofURL(url);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofURL(@NotNull URL url, @NotNull ImageCache cache) {
        return Companion.ofURL(url, cache);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofResource(@NotNull String path) {
        return Companion.ofResource(path);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofResourceCached(@NotNull String path) {
        return Companion.ofResourceCached(path);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofResourceCached(@NotNull String path, @NotNull ResourceCache resourceCache) {
        return Companion.ofResourceCached(path, resourceCache);
    }

    @JvmStatic
    @NotNull
    public static final BufferedImage get(@NotNull URL url) {
        return Companion.get(url);
    }

    static {
        Inspector.Companion.registerComponentFactory$default(Inspector.Companion, Companion.class, null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage$Companion;", "", "<init>", "()V", "Ljava/net/URL;", "url", "Ljava/awt/image/BufferedImage;", "get", "(Ljava/net/URL;)Ljava/awt/image/BufferedImage;", "Ljava/io/File;", "file", "Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage;", "ofFile", "(Ljava/io/File;)Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage;", "", "path", "ofResource", "(Ljava/lang/String;)Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage;", "ofResourceCached", "Lclub/sk1er/mods/scrollabletooltips/elementa/utils/ResourceCache;", "resourceCache", "(Ljava/lang/String;Lclub/sk1er/mods/scrollabletooltips/elementa/utils/ResourceCache;)Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage;", "ofURL", "(Ljava/net/URL;)Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage;", "Lclub/sk1er/mods/scrollabletooltips/elementa/components/image/ImageCache;", "cache", "(Ljava/net/URL;Lclub/sk1er/mods/scrollabletooltips/elementa/components/image/ImageCache;)Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage;", "defaultResourceCache", "Lclub/sk1er/mods/scrollabletooltips/elementa/utils/ResourceCache;", "getDefaultResourceCache", "()Lgg/essential/elementa/utils/ResourceCache;", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceCache getDefaultResourceCache() {
            return defaultResourceCache;
        }

        @JvmStatic
        @NotNull
        public final UIImage ofFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofFile$lambda$0(file));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync { ImageIO.read(file) }");
            return new UIImage(completableFuture, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final UIImage ofURL(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofURL$lambda$1(url));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync { get(url) }");
            return new UIImage(completableFuture, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final UIImage ofURL(@NotNull URL url, @NotNull ImageCache cache) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofURL$lambda$3(cache, url));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026          }\n            }");
            return new UIImage(completableFuture, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final UIImage ofResource(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofResource$lambda$4(this, path));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026ream(path))\n            }");
            return new UIImage(completableFuture, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final UIImage ofResourceCached(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.ofResourceCached(path, this.getDefaultResourceCache());
        }

        @JvmStatic
        @NotNull
        public final UIImage ofResourceCached(@NotNull String path, @NotNull ResourceCache resourceCache) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)resourceCache, (String)"resourceCache");
            CacheableImage cacheableImage = resourceCache.getUIImage(path);
            Intrinsics.checkNotNull((Object)cacheableImage, (String)"null cannot be cast to non-null type gg.essential.elementa.components.UIImage");
            return (UIImage)cacheableImage;
        }

        @JvmStatic
        @NotNull
        public final BufferedImage get(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.setUseCaches(true);
            connection.addRequestProperty("User-Agent", "Mozilla/4.76 (Elementa)");
            connection.setDoOutput(true);
            BufferedImage bufferedImage = ImageIO.read(connection.getInputStream());
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(connection.inputStream)");
            return bufferedImage;
        }

        private static final BufferedImage ofFile$lambda$0(File $file) {
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            return ImageIO.read($file);
        }

        private static final BufferedImage ofURL$lambda$1(URL $url) {
            Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
            return Companion.get($url);
        }

        private static final BufferedImage ofURL$lambda$3(ImageCache $cache, URL $url) {
            Intrinsics.checkNotNullParameter((Object)$cache, (String)"$cache");
            Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
            BufferedImage bufferedImage = $cache.get($url);
            if (bufferedImage == null) {
                BufferedImage bufferedImage2;
                BufferedImage it = bufferedImage2 = Companion.get($url);
                boolean bl = false;
                $cache.set($url, it);
                bufferedImage = bufferedImage2;
            }
            return bufferedImage;
        }

        private static final BufferedImage ofResource$lambda$4(Companion this$0, String $path) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
            return ImageIO.read(this$0.getClass().getResourceAsStream($path));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lclub/sk1er/mods/scrollabletooltips/elementa/components/UIImage$TextureScalingMode;", "", "", "glMode", "<init>", "(Ljava/lang/String;II)V", "I", "getGlMode$Elementa", "()I", "NEAREST", "LINEAR", "NEAREST_MIPMAP_NEAREST", "LINEAR_MIPMAP_NEAREST", "NEAREST_MIPMAP_LINEAR", "LINEAR_MIPMAP_LINEAR", "Elementa"})
    public static final class TextureScalingMode
    extends Enum<TextureScalingMode> {
        private final int glMode;
        public static final /* enum */ TextureScalingMode NEAREST = new TextureScalingMode(9728);
        public static final /* enum */ TextureScalingMode LINEAR = new TextureScalingMode(9729);
        public static final /* enum */ TextureScalingMode NEAREST_MIPMAP_NEAREST = new TextureScalingMode(9984);
        public static final /* enum */ TextureScalingMode LINEAR_MIPMAP_NEAREST = new TextureScalingMode(9985);
        public static final /* enum */ TextureScalingMode NEAREST_MIPMAP_LINEAR = new TextureScalingMode(9986);
        public static final /* enum */ TextureScalingMode LINEAR_MIPMAP_LINEAR = new TextureScalingMode(9987);
        private static final /* synthetic */ TextureScalingMode[] $VALUES;

        private TextureScalingMode(int glMode) {
            this.glMode = glMode;
        }

        public final int getGlMode$Elementa() {
            return this.glMode;
        }

        public static TextureScalingMode[] values() {
            return (TextureScalingMode[])$VALUES.clone();
        }

        public static TextureScalingMode valueOf(String value) {
            return Enum.valueOf(TextureScalingMode.class, value);
        }

        static {
            $VALUES = textureScalingModeArray = new TextureScalingMode[]{TextureScalingMode.NEAREST, TextureScalingMode.LINEAR, TextureScalingMode.NEAREST_MIPMAP_NEAREST, TextureScalingMode.LINEAR_MIPMAP_NEAREST, TextureScalingMode.NEAREST_MIPMAP_LINEAR, TextureScalingMode.LINEAR_MIPMAP_LINEAR};
        }
    }
}

